










                                     Appendix B

                             CODING A BGii SCREEN DRIVER


          BGii provides a uniform interface  for the many varieties of CP/M
          terminals and video   consoles.   Since it's impossible for us to
          supply drivers for more than a few, we are making the source code
          available in both printed and machine readable form.

          If you develop a driver for a new terminal, we hope you will make
          the code available to  other  BGii  users.   Many bulletin boards
          around  the  country  have  expressed  willingness   to   act  as
          clearinghouses for this information.



          B.1  TYPES OF CONSOLE DEVICES

          To implement all of  BackGrounder  ii's  screen-related features,
          BGii needs a screen driver that can:
             -  determine the cursor location on the screen,
             -  read the entire screen, including attributes.

          There are several types of output console devices:
             -  video-mapped memory screens
                   *  video ram accessible in banked memory
                   *  video ram accessed through a video controller
             -  terminals
                   *  transmit screen region
                   *  transmit character at the cursor
                   *  multiple screen page memory

          The prototype code illustrates several variations:
          Kaypro '83:    video ram  in  banked  memory,  no transmit-cursor
                         command

          Kaypro '84:    video accessed thru controller, cursor  indirectly
                         determined from commands and registers

          Heath/Zenith 19:
                         transmit  screen  region commands  with  attribute
                         codes embedded in stream
          A very smart terminal may have several switchable pages of screen
          memory. If the terminal can be caused to copy its  current screen
          to a designated page and to switch pages in  response  to  escape
          sequences,  most  of  the screen save/restore work can be done by
          the terminal itself  as  a  parallel  process.    This  degree of
          intelligence could  also  be  included  in  a  terminal emulation











          program, for example, when  a  computer is used as a terminal for
          another host that is running BGii.

          BGii calls the screen driver entry points with a  flags  byte  in
          register  A.    If bit 1 is set,  the    upper  task  is  active;
          otherwise, the lower task.

          The code has  been  kept  in  two sections: a "generic" part that
          should apply to almost any terminal, and a  "specific"  part that
          must be customized  for  the features of the particular terminal.
          The driver runs at  4000H  (configurable)  and interfaces to BGii
          through  a  jump  table. The code cannot exceed 2K and the sum of
          the data areas and code cannot exceed 4K.



          B.2  SCREEN DRIVER FUNCTIONS

          The  major  screen  driver functions are summarized  here.    For
          details, study the prototype code.


          B.2.1  Screen-Save

            1.  Find the cursor position:
                   -  if available, use transmit-cursor-position
                   -  else, read entire screen, write  signature character,
                      read screen again until signature found

            2.  Read entire screen:
                   -  if necessary, home cursor
                   -  transmit character(s) from screen
                   -  transmit attribute(s) from screen
                   -  if needed, repeat for 25th(status) line


          B.2.2  Screen-Restore

            1.  If necessary, home cursor.

            2.  Clear attributes.

            3.  Write entire saved screen, including attributes.

            4.  Set cursor to saved position.


          B.2.3  Cut-Region

            1.  Edit keystrokes:
                   -  allow cursor movement(but prevent going off screen or
                      scrolling), until X or x
                   -  set first mark
                   -  allow  only  cursor  right,  cursor down, but prevent
                      going off screen, or scrolling


                                        - 2 -








                   -  highlight or blink  the  marked  region  as  it grows
                      until X, x, or CR
                   -  set second mark

            2.  Write cut region to BG:
                   -  calculate byte count, number of rows,  and  number of
                      columns
                   -  send each char in row
                   -  add CR at end of row


          B.2.4  Jot
          The JOT  command  uses  whatever  control-characters  and  ESCape
          sequences the  terminal/video  driver  has.    If  space permits,
                                                       1
          additional editing commands can be installed.
            1.  Clear screen.

            2.  Display 2-line summary of editing command.

            3.  Edit entered keystrokes:
                   -  convert CR to CR,LF
                   -  convert DEL to BS,SPACE,BS
                   -  on CTRL-P, call paste-region
                   -  on CTRL-D, abort
                   -  send anything else to screen


          B.2.5  Paste-Region

            1.  get bytecount, rows, cols from BGii's last cut-region

            2.  get 1st row, put on screen at cursor

            3.  get next row, put vertically below cursor,...etc.

            4.  prevent going off screen, or scrolling

          -----------

          1. See H/Z-19 driver for an  example  of  WordStar cursor-control
             keys.















                                        - 3 -


                                              